/**************************************************************************

	rCE (DLL)

	main.c

	(C) Copyright 2001 By Tomoaki Nakashima. All right reserved.
		http://www.nakka.com/
		nakka@nakka.com

**************************************************************************/

/**************************************************************************
	Include Files
**************************************************************************/

#include <windows.h>
#include <tchar.h>

#include "compress.h"
#include "bitmap.h"


/**************************************************************************
	Define
**************************************************************************/

#define TMP_FILE					TEXT("\\rCE.dat")

#define WM_LBUTTONCLICK				(WM_USER + 10)
#define WM_LBUTTONDOWNMOVE			(WM_USER + 11)
#define WM_MOUSEMOVE_MSG			(WM_USER + 100)
#define WM_LBUTTONDOWN_MSG			(WM_USER + 101)
#define WM_LBUTTONUP_MSG			(WM_USER + 102)
#define WM_LBUTTONCLICK_MSG			(WM_USER + 103)
#define WM_LBUTTONDBLCLK_MSG		(WM_USER + 104)
#define WM_LBUTTONDOWNMOVE_MSG		(WM_USER + 105)


/**************************************************************************
	Global Variables
**************************************************************************/

static HINSTANCE hInst;

typedef struct _RCE_INIT {
	int x;
	int y;
} RCE_INIT;

typedef struct _RCE_INFO {
	int cebits;
	int rcebits;
	int compression;
	int diff;
	int init_diff;
} RCE_INFO;

typedef struct _RCE_MSG {
	UINT message;
    WPARAM wParam;
    LPARAM lParam;
	int oldx;
	int oldy;
} RCE_MSG;


/**************************************************************************
	Local Function Prototypes
**************************************************************************/

static BOOL SaveByte(TCHAR *file, BYTE *buf, int len);
static BYTE *ReadByte(TCHAR *path, long FileSize);
static BOOL memdiff(long *to, long *from, int size);


/******************************************************************************

	DllMain

	DllMain

******************************************************************************/

STDAPI_(BOOL) APIENTRY DllMain(HANDLE hDll, DWORD dwReason, LPVOID lpReserved)
{
    switch( dwReason )
    {
    case DLL_PROCESS_ATTACH:
        hInst = (HINSTANCE)hDll;
        break;

    case DLL_PROCESS_DETACH:
    case DLL_THREAD_ATTACH:
    case DLL_THREAD_DETACH:
        break;
    }
    return TRUE;
}


/******************************************************************************

	RceInit

	擾

******************************************************************************/

STDAPI RceInit(DWORD cbInput, BYTE *pInput, DWORD *pcbOutput, BYTE **ppOutput, void *pIRAPIStream)
{
	RCE_INIT *ri;

	*ppOutput = NULL;
	*pcbOutput = 0;

	ri = (RCE_INIT *)LocalAlloc(LPTR, sizeof(RCE_INIT));
	if(ri == NULL){
        return S_FALSE;
	}
	ri->x = GetSystemMetrics(SM_CXSCREEN);
	ri->y = GetSystemMetrics(SM_CYSCREEN);

    *ppOutput = (PBYTE)ri;
    *pcbOutput = sizeof(RCE_INIT);
	return S_OK;
}


/******************************************************************************

	RceEvent

	Cxg

******************************************************************************/

STDAPI RceEvent(DWORD cbInput, BYTE *pInput, DWORD *pcbOutput, BYTE **ppOutput, void *pIRAPIStream)
{
	RCE_MSG *rm = (RCE_MSG *)pInput;
	HWND hWnd;
	POINT pt;
	HLOCAL hMem;

	*ppOutput = NULL;
	*pcbOutput = 0;

	switch(rm->message)
	{
	case WM_KEYDOWN:
	case WM_SYSKEYDOWN:
		keybd_event((BYTE)rm->wParam, 0, 0, 0);
		break;

	case WM_KEYUP:
	case WM_SYSKEYUP:
		keybd_event((BYTE)rm->wParam, 0, KEYEVENTF_KEYUP, 0);
		break;

	case WM_IME_CHAR:
		{
			char from[4];

			hMem = LocalAlloc(LPTR, sizeof(WCHAR) * 2);

			from[0] = (char)(rm->wParam >> 8);
			from[1] = (char)(rm->wParam & 0xff);
			from[2] = '\0';
			MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, from, -1, (WCHAR *)hMem, 2);
		}

		if(!OpenClipboard(NULL)){
			break;
		}
		EmptyClipboard();
		SetClipboardData(CF_UNICODETEXT, hMem);
		CloseClipboard();

		keybd_event(VK_CONTROL, 0, 0, 0);
		keybd_event('V', 0, 0, 0);
		keybd_event('V', 0, KEYEVENTF_KEYUP, 0);
		keybd_event(VK_CONTROL, 0, KEYEVENTF_KEYUP, 0);
		break;

	case WM_MOUSEMOVE:
		mouse_event(MOUSEEVENTF_MOVE, LOWORD(rm->lParam) - rm->oldx, HIWORD(rm->lParam) - rm->oldy, 0, 0);
		break;

	case WM_LBUTTONDOWN:
		mouse_event(MOUSEEVENTF_MOVE | MOUSEEVENTF_ABSOLUTE, 0, 0, 0, 0);
		mouse_event(MOUSEEVENTF_LEFTDOWN, LOWORD(rm->lParam), HIWORD(rm->lParam), 0, 0);
		break;

	case WM_LBUTTONUP:
		mouse_event(MOUSEEVENTF_LEFTUP, LOWORD(rm->lParam) - rm->oldx, HIWORD(rm->lParam) - rm->oldy, 0, 0);
		break;

	case WM_LBUTTONCLICK:
		mouse_event(MOUSEEVENTF_MOVE | MOUSEEVENTF_ABSOLUTE, 0, 0, 0, 0);
		mouse_event(MOUSEEVENTF_LEFTDOWN, LOWORD(rm->lParam), HIWORD(rm->lParam), 0, 0);
		mouse_event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);
		break;

	case WM_LBUTTONDBLCLK:
		mouse_event(MOUSEEVENTF_MOVE | MOUSEEVENTF_ABSOLUTE, 0, 0, 0, 0);
		mouse_event(MOUSEEVENTF_LEFTDOWN, LOWORD(rm->lParam), HIWORD(rm->lParam), 0, 0);
		mouse_event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);
		Sleep(100);
		mouse_event(MOUSEEVENTF_LEFTDOWN, 0, 0, 0, 0);
		mouse_event(MOUSEEVENTF_LEFTUP, 0, 0, 0, 0);
		break;

	case WM_LBUTTONDOWNMOVE:
		mouse_event(MOUSEEVENTF_MOVE | MOUSEEVENTF_ABSOLUTE, 0, 0, 0, 0);
		mouse_event(MOUSEEVENTF_LEFTDOWN, rm->oldx, rm->oldy, 0, 0);
		Sleep(100);
		mouse_event(MOUSEEVENTF_MOVE, LOWORD(rm->lParam) - rm->oldx, HIWORD(rm->lParam) - rm->oldy, 0, 0);
		break;

	case WM_MOUSEMOVE_MSG:
		pt.x = LOWORD(rm->lParam);
		pt.y = HIWORD(rm->lParam);
		hWnd = WindowFromPoint(pt);
		ScreenToClient(hWnd, &pt);
		PostMessage(hWnd, WM_MOUSEMOVE, rm->wParam, MAKELPARAM(pt.x, pt.y));
		break;

	case WM_LBUTTONDOWN_MSG:
		pt.x = LOWORD(rm->lParam);
		pt.y = HIWORD(rm->lParam);
		hWnd = WindowFromPoint(pt);
		ScreenToClient(hWnd, &pt);
		SetForegroundWindow(hWnd);
		PostMessage(hWnd, WM_LBUTTONDOWN, rm->wParam, MAKELPARAM(pt.x, pt.y));
		break;

	case WM_LBUTTONUP_MSG:
		pt.x = LOWORD(rm->lParam);
		pt.y = HIWORD(rm->lParam);
		hWnd = WindowFromPoint(pt);
		ScreenToClient(hWnd, &pt);
		PostMessage(hWnd, WM_LBUTTONUP, rm->wParam, MAKELPARAM(pt.x, pt.y));
		break;

	case WM_LBUTTONCLICK_MSG:
		pt.x = LOWORD(rm->lParam);
		pt.y = HIWORD(rm->lParam);
		hWnd = WindowFromPoint(pt);
		ScreenToClient(hWnd, &pt);
		SetForegroundWindow(hWnd);
		PostMessage(hWnd, WM_LBUTTONDOWN, rm->wParam, MAKELPARAM(pt.x, pt.y));
		PostMessage(hWnd, WM_LBUTTONUP, rm->wParam, MAKELPARAM(pt.x, pt.y));
		break;

	case WM_LBUTTONDBLCLK_MSG:
		pt.x = LOWORD(rm->lParam);
		pt.y = HIWORD(rm->lParam);
		hWnd = WindowFromPoint(pt);
		ScreenToClient(hWnd, &pt);
		SetForegroundWindow(hWnd);
		PostMessage(hWnd, WM_LBUTTONDOWN, rm->wParam, MAKELPARAM(pt.x, pt.y));
		PostMessage(hWnd, WM_LBUTTONUP, rm->wParam, MAKELPARAM(pt.x, pt.y));
		Sleep(100);
		PostMessage(hWnd, WM_LBUTTONDBLCLK, rm->wParam, MAKELPARAM(pt.x, pt.y));
		PostMessage(hWnd, WM_LBUTTONUP, rm->wParam, MAKELPARAM(pt.x, pt.y));
		break;

	case WM_LBUTTONDOWNMOVE_MSG:
		pt.x = rm->oldx;
		pt.y = rm->oldy;
		hWnd = WindowFromPoint(pt);
		ScreenToClient(hWnd, &pt);
		SetForegroundWindow(hWnd);
		PostMessage(hWnd, WM_LBUTTONDOWN, rm->wParam, MAKELPARAM(pt.x, pt.y));

		pt.x = LOWORD(rm->lParam);
		pt.y = HIWORD(rm->lParam);
		hWnd = WindowFromPoint(pt);
		ScreenToClient(hWnd, &pt);
		PostMessage(hWnd, WM_MOUSEMOVE, rm->wParam, MAKELPARAM(pt.x, pt.y));
		break;
	}
    return S_OK;
}


/******************************************************************************

	RceSendText

	񑗐M

******************************************************************************/

STDAPI RceSendText(DWORD cbInput, BYTE *pInput, DWORD *pcbOutput, BYTE **ppOutput, void *pIRAPIStream)
{
	HLOCAL hMem;

	*ppOutput = NULL;
	*pcbOutput = 0;

	hMem = LocalAlloc(LPTR, sizeof(WCHAR) * (cbInput + 1));
	MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, pInput, cbInput, (WCHAR *)hMem, cbInput);

	if(!OpenClipboard(NULL)){
	   return S_OK;
	}
	EmptyClipboard();
	SetClipboardData(CF_UNICODETEXT, hMem);
	CloseClipboard();

	keybd_event(VK_CONTROL, 0, 0, 0);
	keybd_event('V', 0, 0, 0);
	keybd_event('V', 0, KEYEVENTF_KEYUP, 0);
	keybd_event(VK_CONTROL, 0, KEYEVENTF_KEYUP, 0);
    return S_OK;
}


/******************************************************************************

	GetRemoteDib

	摜擾

******************************************************************************/

STDAPI GetRemoteDib(DWORD cbInput, BYTE *pInput, DWORD *pcbOutput, BYTE **ppOutput, void *pIRAPIStream)
{
	RCE_INFO *ri = (RCE_INFO *)pInput;
	BYTE *buf, *ret, *tmp, *fbuf;
	int x, y;
	int len;
	int size;

	*ppOutput = NULL;
	*pcbOutput = 0;

	x = GetSystemMetrics(SM_CXSCREEN);
	y = GetSystemMetrics(SM_CYSCREEN);

	//XN[摜擾
	buf = GetScreenDib(x, y, ri->cebits, ri->rcebits, &size);
	if(buf == NULL){
		return S_FALSE;
	}

	if(ri->init_diff != 0){
		//
		SaveByte(TMP_FILE, buf, size);
	}else if(ri->diff != 0){
		fbuf = ReadByte(TMP_FILE, size);
		SaveByte(TMP_FILE, buf, size);

		if(fbuf != NULL){
			//擾
			if(memdiff((long *)buf, (long *)fbuf, size / sizeof(long)) == FALSE){
				//OƂ̕ωȂ
				LocalFree(fbuf);
				LocalFree(buf);
				return S_OK;
			}
			LocalFree(fbuf);
		}
	}
	if(ri->compression != 0){
		//k
		tmp = (BYTE *)LocalAlloc(LMEM_FIXED, size);
		if(tmp == NULL){
			LocalFree(buf);
			return S_FALSE;
		}
		len = compress(buf, size, tmp, (ri->cebits == 24) ? ri->rcebits : ri->cebits);
		LocalFree(buf);
		ret = (BYTE *)LocalAlloc(LMEM_FIXED, len);
		if(ret == NULL){
			LocalFree(tmp);
			return S_FALSE;
		}
		memcpy(ret, tmp, len);
		LocalFree(tmp);
	}else{
		ret = buf;
		len = size;
	}

	if(ret == NULL){
	    return S_FALSE;
	}
	*ppOutput = (PBYTE)ret;
	*pcbOutput = len;
    return S_OK;
}


/******************************************************************************

	SaveByte

	oCgt@Cɕۑ

******************************************************************************/

static BOOL SaveByte(TCHAR *file, BYTE *buf, int len)
{
	HANDLE hFile;
	DWORD ret;

	//ۑt@CJ
	hFile = CreateFile(file, GENERIC_READ | GENERIC_WRITE, 0, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile == NULL || hFile == (HANDLE)-1){
		return FALSE;
	}
	if(WriteFile(hFile, buf, len, &ret, NULL) == FALSE){
		CloseHandle(hFile);
		return FALSE;
	}
	CloseHandle(hFile);
	return TRUE;
}


/******************************************************************************

	ReadByte

	t@CoCgǂݍ

******************************************************************************/

static BYTE *ReadByte(TCHAR *path, long FileSize)
{
	HANDLE hFile;
	DWORD ret;
	BYTE *cBuf;

	//t@CJ
	hFile = CreateFile(path, GENERIC_READ, 0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if(hFile == NULL || hFile == (HANDLE)-1){
		return NULL;
	}
	cBuf = (BYTE *)LocalAlloc(LPTR, FileSize + 1);
	if(cBuf == NULL){
		CloseHandle(hFile);
		return NULL;
	}

	if(ReadFile(hFile, cBuf, FileSize, &ret, NULL) == FALSE){
		LocalFree(cBuf);
		CloseHandle(hFile);
		return NULL;
	}
	CloseHandle(hFile);
	return cBuf;
}


/******************************************************************************

	memdiff

	̍

******************************************************************************/

static BOOL memdiff(long *to, long *from, int size)
{
	int i;

	for(i = 0; i < size; i++){
		*(to + i) = *(to + i) ^ *(from + i);
	}
	for(i = 0; i < size; i++){
		if(*(to + i)){
			return TRUE;
		}
	}
	return FALSE;
}
/* End of source */
