/**************************************************************************

	rCE

	compress.c

	(C) Copyright 2001 By Tomoaki Nakashima. All right reserved.
		http://www.nakka.com/
		nakka@nakka.com

**************************************************************************/

/**************************************************************************
	Include Files
**************************************************************************/

#include <memory.h>


/******************************************************************************

	compress

	f[^k

******************************************************************************/

long compress(unsigned char *text, long tlen, unsigned char *code, int bit)
{
#define MAX_INFO		4096
	short sdata;
	unsigned char *p, *r = code;
	unsigned char c[10];
	int i = 0, j;
	int byte;

	byte = bit / 8;
	if(byte <= 0) byte = 1;

	while(i < tlen){
		memcpy(c, text + i, byte);
		if(memcmp(c, (text + (i + byte)), byte) == 0){
			//JԂ
			for(i += byte, sdata = 1;
				(i + byte) < tlen && sdata < MAX_INFO && memcmp(c, (text + i), byte) == 0;
				i += byte, sdata++);
			*(r++) = (char)((sdata >> 8) & 0xFF);
			*(r++) = (char)(sdata & 0xFF);
			memcpy(r, c, byte);
			r += byte;
		}else{
			//
			p = r;
			r += 2;
			for(sdata = 0;
				(i + byte) < tlen && sdata < MAX_INFO && memcmp((text + i), (text + i + byte), byte) != 0;
				i += byte, r += byte, sdata += byte){
				memcpy(r, (text + i), byte);
			}
			*(p++) = (char)(((sdata * -1) >> 8) & 0xFF);
			*p = (char)((sdata * -1) & 0xFF);
		}
		if((i + byte) >= tlen){
			//I[
			sdata = tlen - i;
			*(r++) = (char)(((sdata * -1) >> 8) & 0xFF);
			*(r++) = (char)((sdata * -1) & 0xFF);
			for(j = 0; j < sdata; j++, i++){
				*(r++) = *(text + i);
			}
			break;
		}
	}
	return (r - code);
}


/******************************************************************************

	extend

	f[^WJ

******************************************************************************/

long extend(unsigned char *code, long clen, unsigned char *text, int bit)
{
	short sdata;
	unsigned char *p = code;
	unsigned char *r = text;
	int i;
	int byte;

	byte = bit / 8;
	if(byte <= 0) byte = 1;

	while((p - code) < clen){
		sdata = (short)*(p++) << 8;
		sdata |= *(p++);
		if(sdata > 0){
			//JԂ
			for(i = 0; i < sdata; i++){
				memcpy(r, p, byte);
				r += byte;
			}
			p += byte;
		}else{
			//
			sdata *= -1;
			for(i = 0; i < sdata; i++){
				*(r++) = *(p++);
			}
		}
	}
	return (r - text);

}
/* End of source */
