/**************************************************************************

	rCE (DLL)

	bitmap.c

	(C) Copyright 2001 By Tomoaki Nakashima. All right reserved.
		http://www.nakka.com/
		nakka@nakka.com

**************************************************************************/

/**************************************************************************
	Include Files
**************************************************************************/

#include <windows.h>


/**************************************************************************
	Global Variables
**************************************************************************/

//pbg
static RGBQUAD rgbPal[256] = {
	0, 0, 0, 0,
	255, 255, 255, 0,
	//2F܂
	192, 192, 192, 0,
	128, 128, 128, 0,
	//4F܂
	128, 0, 0, 0,
	0, 255, 255, 0,
	255, 255, 0, 0,
	255, 0, 255, 0,
	255, 0, 0, 0,
	0, 255, 0, 0,
	0, 0, 255, 0,
	128, 128, 0, 0,
	128, 0, 128, 0,
	0, 128, 128, 0,
	0, 128, 0, 0,
	0, 0, 128, 0,
	//16F܂
	192, 220, 192, 0,
	166, 202, 240, 0,
	4, 4, 4, 0,
	8, 8, 8, 0,
	12, 12, 12, 0,
	17, 17, 17, 0,
	22, 22, 22, 0,
	28, 28, 28, 0,
	34, 34, 34, 0,
	41, 41, 41, 0,
	85, 85, 85, 0,
	77, 77, 77, 0,
	66, 66, 66, 0,
	57, 57, 57, 0,
	255, 124, 128, 0,
	255, 80, 80, 0,
	214, 0, 147, 0,
	204, 236, 255, 0,
	239, 214, 198, 0,
	231, 231, 214, 0,
	173, 169, 144, 0,
	51, 0, 0, 0,
	102, 0, 0, 0,
	153, 0, 0, 0,
	204, 0, 0, 0,
	0, 51, 0, 0,
	51, 51, 0, 0,
	102, 51, 0, 0,
	153, 51, 0, 0,
	204, 51, 0, 0,
	255, 51, 0, 0,
	0, 102, 0, 0,
	51, 102, 0, 0,
	102, 102, 0, 0,
	153, 102, 0, 0,
	204, 102, 0, 0,
	255, 102, 0, 0,
	0, 153, 0, 0,
	51, 153, 0, 0,
	102, 153, 0, 0,
	153, 153, 0, 0,
	204, 153, 0, 0,
	255, 153, 0, 0,
	0, 204, 0, 0,
	51, 204, 0, 0,
	102, 204, 0, 0,
	153, 204, 0, 0,
	204, 204, 0, 0,
	255, 204, 0, 0,
	102, 255, 0, 0,
	153, 255, 0, 0,
	204, 255, 0, 0,
	0, 0, 51, 0,
	51, 0, 51, 0,
	102, 0, 51, 0,
	153, 0, 51, 0,
	204, 0, 51, 0,
	255, 0, 51, 0,
	0, 51, 51, 0,
	51, 51, 51, 0,
	102, 51, 51, 0,
	153, 51, 51, 0,
	204, 51, 51, 0,
	255, 51, 51, 0,
	0, 102, 51, 0,
	51, 102, 51, 0,
	102, 102, 51, 0,
	153, 102, 51, 0,
	204, 102, 51, 0,
	255, 102, 51, 0,
	0, 153, 51, 0,
	51, 153, 51, 0,
	102, 153, 51, 0,
	153, 153, 51, 0,
	204, 153, 51, 0,
	255, 153, 51, 0,
	0, 204, 51, 0,
	51, 204, 51, 0,
	102, 204, 51, 0,
	153, 204, 51, 0,
	204, 204, 51, 0,
	255, 204, 51, 0,
	51, 255, 51, 0,
	102, 255, 51, 0,
	153, 255, 51, 0,
	204, 255, 51, 0,
	255, 255, 51, 0,
	0, 0, 102, 0,
	51, 0, 102, 0,
	102, 0, 102, 0,
	153, 0, 102, 0,
	204, 0, 102, 0,
	255, 0, 102, 0,
	0, 51, 102, 0,
	51, 51, 102, 0,
	102, 51, 102, 0,
	153, 51, 102, 0,
	204, 51, 102, 0,
	255, 51, 102, 0,
	0, 102, 102, 0,
	51, 102, 102, 0,
	102, 102, 102, 0,
	153, 102, 102, 0,
	204, 102, 102, 0,
	0, 153, 102, 0,
	51, 153, 102, 0,
	102, 153, 102, 0,
	153, 153, 102, 0,
	204, 153, 102, 0,
	255, 153, 102, 0,
	0, 204, 102, 0,
	51, 204, 102, 0,
	153, 204, 102, 0,
	204, 204, 102, 0,
	255, 204, 102, 0,
	0, 255, 102, 0,
	51, 255, 102, 0,
	153, 255, 102, 0,
	204, 255, 102, 0,
	255, 0, 204, 0,
	204, 0, 255, 0,
	0, 153, 153, 0,
	153, 51, 153, 0,
	153, 0, 153, 0,
	204, 0, 153, 0,
	0, 0, 153, 0,
	51, 51, 153, 0,
	102, 0, 153, 0,
	204, 51, 153, 0,
	255, 0, 153, 0,
	0, 102, 153, 0,
	51, 102, 153, 0,
	102, 51, 153, 0,
	153, 102, 153, 0,
	204, 102, 153, 0,
	255, 51, 153, 0,
	51, 153, 153, 0,
	102, 153, 153, 0,
	153, 153, 153, 0,
	204, 153, 153, 0,
	255, 153, 153, 0,
	0, 204, 153, 0,
	51, 204, 153, 0,
	102, 204, 102, 0,
	153, 204, 153, 0,
	204, 204, 153, 0,
	255, 204, 153, 0,
	0, 255, 153, 0,
	51, 255, 153, 0,
	102, 204, 153, 0,
	153, 255, 153, 0,
	204, 255, 153, 0,
	255, 255, 153, 0,
	0, 0, 204, 0,
	51, 0, 153, 0,
	102, 0, 204, 0,
	153, 0, 204, 0,
	204, 0, 204, 0,
	0, 51, 153, 0,
	51, 51, 204, 0,
	102, 51, 204, 0,
	153, 51, 204, 0,
	204, 51, 204, 0,
	255, 51, 204, 0,
	0, 102, 204, 0,
	51, 102, 204, 0,
	102, 102, 153, 0,
	153, 102, 204, 0,
	204, 102, 204, 0,
	255, 102, 153, 0,
	0, 153, 204, 0,
	51, 153, 204, 0,
	102, 153, 204, 0,
	153, 153, 204, 0,
	204, 153, 204, 0,
	255, 153, 204, 0,
	0, 204, 204, 0,
	51, 204, 204, 0,
	102, 204, 204, 0,
	153, 204, 204, 0,
	204, 204, 204, 0,
	255, 204, 204, 0,
	0, 255, 204, 0,
	51, 255, 204, 0,
	102, 255, 153, 0,
	153, 255, 204, 0,
	204, 255, 204, 0,
	255, 255, 204, 0,
	51, 0, 204, 0,
	102, 0, 255, 0,
	153, 0, 255, 0,
	0, 51, 204, 0,
	51, 51, 255, 0,
	102, 51, 255, 0,
	153, 51, 255, 0,
	204, 51, 255, 0,
	255, 51, 255, 0,
	0, 102, 255, 0,
	51, 102, 255, 0,
	102, 102, 204, 0,
	153, 102, 255, 0,
	204, 102, 255, 0,
	255, 102, 204, 0,
	0, 153, 255, 0,
	51, 153, 255, 0,
	102, 153, 255, 0,
	153, 153, 255, 0,
	204, 153, 255, 0,
	255, 153, 255, 0,
	0, 204, 255, 0,
	51, 204, 255, 0,
	102, 204, 255, 0,
	153, 204, 255, 0,
	204, 204, 255, 0,
	255, 204, 255, 0,
	51, 255, 255, 0,
	102, 255, 204, 0,
	153, 255, 255, 0,
	204, 255, 255, 0,
	255, 102, 102, 0,
	102, 255, 102, 0,
	255, 255, 102, 0,
	102, 102, 255, 0,
	255, 102, 255, 0,
	102, 255, 255, 0,
	165, 0, 33, 0,
	95, 95, 95, 0,
	119, 119, 119, 0,
	134, 134, 134, 0,
	150, 150, 150, 0,
	203, 203, 203, 0,
	178, 178, 178, 0,
	215, 215, 215, 0,
	221, 221, 221, 0,
	227, 227, 227, 0,
	234, 234, 234, 0,
	241, 241, 241, 0,
	248, 248, 248, 0,
	255, 251, 240, 0,
	160, 160, 164, 0,
};


/******************************************************************************

	Create4bitBitmap

	24bitrbg}bv2Frbg}bvɕϊ

******************************************************************************/

static BYTE *Create1bitBitmap(BYTE *lpPixel, DWORD dwWidth, DWORD dwHeight)
{
	PBITMAPINFO pbmi;
	DWORD dwWLength;
	DWORD dwLength;
	DWORD r,g,b;
	DWORD i, j;
	LPBYTE lpWPixels;

	dwLength = (dwWidth * 3 % 4 == 0) ? dwWidth * 3 : dwWidth * 3 + (4 - (dwWidth * 3) % 4);
	dwWLength = ((dwWidth / 8) % 4) ? (((dwWidth / 8) / 4) + 1) * 4 : dwWidth / 8;

	pbmi = (PBITMAPINFO)LocalAlloc(LPTR, sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (2 - 1) + dwHeight * dwWLength);
	//DIBwb_
	pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	pbmi->bmiHeader.biWidth = dwWidth;
	pbmi->bmiHeader.biHeight = dwHeight;
	pbmi->bmiHeader.biPlanes = 1;
	pbmi->bmiHeader.biBitCount = 1;
	pbmi->bmiHeader.biCompression = BI_RGB;
	pbmi->bmiHeader.biSizeImage = dwHeight * dwWLength;
	pbmi->bmiHeader.biClrImportant = 0;
	memcpy((LPBYTE)pbmi + sizeof(BITMAPINFOHEADER), rgbPal, 2 * sizeof(RGBQUAD));
	lpWPixels = (LPBYTE)pbmi + sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (2 - 1);

	for(i = 0; i < dwHeight; i++){
		for(j = 0; j < dwWidth; j++){
			b = *(lpPixel + j * 3 + i * dwLength);
			g = *(lpPixel + j * 3 + i * dwLength + 1);
			r = *(lpPixel + j * 3 + i * dwLength + 2);

			if((r - 0) * (r - 0) + (g - 0) * (g - 0) + (b - 0) * (b - 0) >
				(r - 255) * (r - 255) + (g - 255) * (g - 255) + (b - 255) * (b - 255)){
				*(lpWPixels + (j / 8) + i * dwWLength) |= (BYTE)(1 << (8 - (j % 8) - 1));
			}
		}
	}
	return (BYTE *)pbmi;
}


/******************************************************************************

	Create4bitBitmap

	24bitrbg}bv16Frbg}bvɕϊ

******************************************************************************/

static BYTE *Create4bitBitmap(BYTE *lpPixel, DWORD dwWidth, DWORD dwHeight, DWORD clr)
{
	PBITMAPINFO pbmi;
	DWORD dwWLength,dwDis,dwMin;
	DWORD dwLength;
	DWORD r,g,b,pr,pg,pb;
	DWORD i,j,k,no;
	LPBYTE lpWPixels;

	dwLength = (dwWidth * 3 % 4 == 0) ? dwWidth * 3 : dwWidth * 3 + (4 - (dwWidth * 3) % 4);
	dwWLength = (((dwWidth * 4) / 8) % 4) ? ((((dwWidth * 4) / 8) / 4) + 1) * 4 : (dwWidth * 4) / 8;

	pbmi = (PBITMAPINFO)LocalAlloc(LMEM_FIXED, sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (16 - 1) + dwHeight * dwWLength);
	//DIBwb_
	memset(pbmi, 0, sizeof(BITMAPINFO));
	pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	pbmi->bmiHeader.biWidth = dwWidth;
	pbmi->bmiHeader.biHeight = dwHeight;
	pbmi->bmiHeader.biPlanes = 1;
	pbmi->bmiHeader.biBitCount = 4;
	pbmi->bmiHeader.biCompression = BI_RGB;
	pbmi->bmiHeader.biSizeImage = dwHeight * dwWLength;
	pbmi->bmiHeader.biClrImportant = 0;
	memcpy((LPBYTE)pbmi + sizeof(BITMAPINFOHEADER), rgbPal, 16 * sizeof(RGBQUAD));
	lpWPixels = (LPBYTE)pbmi + sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (16 - 1);

	for(i = 0; i < dwHeight; i++){
		for(j = 0; j < dwWidth; j++){
			b = *(lpPixel + j * 3 + i * dwLength);
			g = *(lpPixel + j * 3 + i * dwLength + 1);
			r = *(lpPixel + j * 3 + i * dwLength + 2);

			//߂F
			for(no = 0, k = 0; k < clr; k++){
				pr = (rgbPal + k)->rgbRed;
				pg = (rgbPal + k)->rgbGreen;
				pb = (rgbPal + k)->rgbBlue;
				dwDis = (r - pr) * (r - pr) + (g - pg) * (g - pg) + (b - pb) * (b - pb);
				if(k == 0){
					dwMin = dwDis;
				}else{
					if(dwMin > dwDis){
						dwMin = dwDis;
						no = k;
					}
				}
				if(dwDis == 0) break;
			}
			if(j % 2){
				*(lpWPixels + (j / 2) + i * dwWLength) |= (BYTE)(no & 0x0F);
			}else{
				*(lpWPixels + (j / 2) + i * dwWLength) = (BYTE)(no << 4);
			}
		}
	}
	return (BYTE *)pbmi;
}


/******************************************************************************

	Create8bitBitmap

	24bitrbg}bv256Frbg}bvɕϊ

******************************************************************************/

static BYTE *Create8bitBitmap(BYTE *lpPixel, DWORD dwWidth, DWORD dwHeight)
{
	PBITMAPINFO pbmi;
	DWORD dwWLength,dwDis,dwMin;
	DWORD dwLength;
	DWORD r,g,b,pr,pg,pb;
	DWORD i,j,k,no;
	LPBYTE lpWPixels;

	dwLength = (dwWidth * 3 % 4 == 0) ? dwWidth * 3 : dwWidth * 3 + (4 - (dwWidth * 3) % 4);
	dwWLength = (((dwWidth * 8) / 8) % 4) ? ((((dwWidth * 8) / 8) / 4) + 1) * 4 : (dwWidth * 8) / 8;

	pbmi = (PBITMAPINFO)LocalAlloc(LMEM_FIXED, sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (256 - 1) + dwHeight * dwWLength);
	//DIBwb_
	memset(pbmi, 0, sizeof(BITMAPINFO));
	pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	pbmi->bmiHeader.biWidth = dwWidth;
	pbmi->bmiHeader.biHeight = dwHeight;
	pbmi->bmiHeader.biPlanes = 1;
	pbmi->bmiHeader.biBitCount = 8;
	pbmi->bmiHeader.biCompression = BI_RGB;
	pbmi->bmiHeader.biSizeImage = dwHeight * dwWLength;
	pbmi->bmiHeader.biClrImportant = 0;
	memcpy((LPBYTE)pbmi + sizeof(BITMAPINFOHEADER), rgbPal, 256 * sizeof(RGBQUAD));
	lpWPixels = (LPBYTE)pbmi + sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (256 - 1);

	for(i = 0; i < dwHeight; i++){
		for(j = 0; j < dwWidth; j++){
			b = *(lpPixel + j * 3 + i * dwLength);
			g = *(lpPixel + j * 3 + i * dwLength + 1);
			r = *(lpPixel + j * 3 + i * dwLength + 2);

			//߂F
			for(no = 0, k = 0; k < 256; k++){
				pr = (rgbPal + k)->rgbRed;
				pg = (rgbPal + k)->rgbGreen;
				pb = (rgbPal + k)->rgbBlue;
				dwDis = (r - pr) * (r - pr) + (g - pg) * (g - pg) + (b - pb) * (b - pb);
				if(k == 0){
					dwMin = dwDis;
				}else{
					if(dwMin > dwDis){
						dwMin = dwDis;
						no = k;
					}
				}
				if(dwDis == 0) break;
			}
			*(lpWPixels + j + i * dwWLength) = (BYTE)no;
		}
	}
	return (BYTE *)pbmi;
}


/******************************************************************************

	GetDib

	XN[DIB擾

******************************************************************************/

BYTE *GetScreenDib(int x, int y, int bits, int tobits, int *size)
{
	HDC hdc;
	HDC drawdc;
	HBITMAP hDrawBitMap;
	HBITMAP hRetDrawBmp;
	PBITMAPINFO pbmi;
	BYTE *buf, *ret;
	int plt = 0;
	int len;

	switch(bits)
	{
	case 1: plt = (2 - 1); break;
	case 4: plt = (16 - 1); break;
	case 8: plt = (256 - 1); break;
	}
	len = (((x * bits) / 8) % 4) ? ((((x * bits) / 8) / 4) + 1) * 4 : (x * bits) / 8;

	hdc = GetDC(NULL);

	pbmi = (PBITMAPINFO)LocalAlloc(LPTR, sizeof(BITMAPINFO) + sizeof(RGBQUAD) * plt);
	//DIBwb_
	pbmi->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
	pbmi->bmiHeader.biWidth = x;
	pbmi->bmiHeader.biHeight = y;
	pbmi->bmiHeader.biPlanes = 1;
	pbmi->bmiHeader.biBitCount = bits;
	pbmi->bmiHeader.biCompression = BI_RGB;
	pbmi->bmiHeader.biSizeImage = len * y;
	pbmi->bmiHeader.biClrImportant = 0;

	switch(bits)
	{
	case 1:
		memcpy((LPBYTE)pbmi + sizeof(BITMAPINFOHEADER), rgbPal, 2 * sizeof(RGBQUAD));
		break;
	case 4:
		memcpy((LPBYTE)pbmi + sizeof(BITMAPINFOHEADER), rgbPal, 16 * sizeof(RGBQUAD));
		break;
	case 8:
		memcpy((LPBYTE)pbmi + sizeof(BITMAPINFOHEADER), rgbPal, 256 * sizeof(RGBQUAD));
		break;
	}

	//rbg}bv̍쐬
	hDrawBitMap = CreateDIBSection(hdc, pbmi, DIB_RGB_COLORS, (VOID **)&buf, NULL, 0);
	drawdc = CreateCompatibleDC(hdc);
	hRetDrawBmp = (HBITMAP)SelectObject(drawdc, (HGDIOBJ)hDrawBitMap);

	BitBlt(drawdc, 0, 0, x, y, hdc, 0, 0, SRCCOPY);

	if(bits == 24 && tobits != 24){
		len = (((x * tobits) / 8) % 4) ? ((((x * tobits) / 8) / 4) + 1) * 4 : (x * tobits) / 8;
		switch(tobits)
		{
		case 1:
			//2FɌF
			ret = Create1bitBitmap(buf, x, y);
			*size = sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (2 - 1) + len * y;
			break;

		case 2:
			//4FɌF
			ret = Create4bitBitmap(buf, x, y, 4);
			len = (((x * 4) / 8) % 4) ? ((((x * 4) / 8) / 4) + 1) * 4 : (x * 4) / 8;
			*size = sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (16 - 1) + len * y;
			break;

		case 4:
			//16FɌF
			ret = Create4bitBitmap(buf, x, y, 16);
			*size = sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (16 - 1) + len * y;
			break;

		case 8:
			//256FɌF
			ret = Create8bitBitmap(buf, x, y);
			*size = sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (256 - 1) + len * y;
			break;
		}
	}else{
		*size = sizeof(BITMAPINFO) + sizeof(RGBQUAD) * plt + len * y;
		ret = LocalAlloc(LMEM_FIXED, *size);
		if(ret != NULL){
			memcpy(ret, pbmi, sizeof(BITMAPINFO) + sizeof(RGBQUAD) * plt);
			memcpy(ret + sizeof(BITMAPINFO) + sizeof(RGBQUAD) * plt, buf, len * y);
		}
	}
	SelectObject(drawdc, hRetDrawBmp);
	DeleteObject(hDrawBitMap);
	DeleteDC(drawdc);
	LocalFree(pbmi);

	ReleaseDC(NULL, hdc);
    return ret;
}
/* End of source */
