/**************************************************************************

	rCE

	main.c

	(C) Copyright 2001 By Tomoaki Nakashima. All right reserved.
		http://www.nakka.com/
		nakka@nakka.com

**************************************************************************/

/**************************************************************************
	Include Files
**************************************************************************/

#include <windows.h>
#include <process.h>

#ifdef _WINCE_LAGENDA
#include "WILRAPI.H"
#else
#include "rapi.h"
#endif
#include "compress.h"
#include "resource.h"


/**************************************************************************
	Define
**************************************************************************/

#define MAIN_WND_CLASS				"rceWndClass"
#define WINDOW_TITLE				"rCE"

#define INI_FILE					"\\rCE.ini"
#define RCE_DLL						"rCE.dll"
#define RCE_DLL_W					L"rCE.dll"
#define RCE_DLL_CE					L"\\rCE.dll"
#define TMP_FILE					L"\\rCE.dat"

#define BUF_SIZE					256

#define ID_CLICK_TIMER				1
#define ID_MOUSEMOVE_TIMER			2

#define WM_BMP_REFRESH				(WM_USER + 1)
#define WM_LBUTTONCLICK				(WM_USER + 10)
#define WM_LBUTTONDOWNMOVE			(WM_USER + 11)
#define WM_MOUSEMOVE_MSG			(WM_USER + 100)
#define WM_LBUTTONDOWN_MSG			(WM_USER + 101)
#define WM_LBUTTONUP_MSG			(WM_USER + 102)
#define WM_LBUTTONCLICK_MSG			(WM_USER + 103)
#define WM_LBUTTONDBLCLK_MSG		(WM_USER + 104)
#define WM_LBUTTONDOWNMOVE_MSG		(WM_USER + 105)

#define WM_DISCONNECT				(WM_USER + 200)

//winnt.h
#define PROCESSOR_MIPS_R2000		2000
#define PROCESSOR_MIPS_R3000		3000
#define PROCESSOR_MIPS_R4000		4000
#define PROCESSOR_HITACHI_SH3		10003   // Windows CE
#define PROCESSOR_HITACHI_SH3E		10004   // Windows CE
#define PROCESSOR_HITACHI_SH4		10005   // Windows CE
#define PROCESSOR_MOTOROLA_821		821     // Windows CE
#define PROCESSOR_SHx_SH3			103     // Windows CE
#define PROCESSOR_SHx_SH4			104     // Windows CE
#define PROCESSOR_STRONGARM			2577    // Windows CE - 0xA11
#define PROCESSOR_ARM720			1824    // Windows CE - 0x720
#define PROCESSOR_ARM820			2080    // Windows CE - 0x820
#define PROCESSOR_ARM920			2336    // Windows CE - 0x920
#define PROCESSOR_ARM_7TDMI			70001   // Windows CE

#define PROCESSOR_ARCHITECTURE_MIPS	1
#define PROCESSOR_ARCHITECTURE_SHX	4
#define PROCESSOR_ARCHITECTURE_ARM	5


/**************************************************************************
	Global Variables
**************************************************************************/

static HINSTANCE hInst;
static HWND hEditDlg;
static WNDPROC EditWindowProcedure;

static HANDLE r_hth;
static unsigned int r_thId;
static HANDLE s_hth;
static unsigned int s_thId;

static BOOL connect_falg;
static BYTE *dib;
static int ce_x;
static int ce_y;

static int op_use_key = 1;
static int op_no_repeat = 0;
static int op_use_mouse = 1;
static int op_mouse_msg = 1;
static int op_auto_refresh = 1;
static int op_refresh_wait = 0;
static int op_cebits = 24;
static int op_rcebits = 4;
static int op_compression = 1;
static int op_diff = 1;

typedef struct _RCE_INIT {
	int x;
	int y;
} RCE_INIT;

typedef struct _RCE_INFO {
	int cebits;
	int rcebits;
	int compression;
	int diff;
	int init_diff;
} RCE_INFO;

typedef struct _RCE_MSG {
	UINT message;
    WPARAM wParam;
    LPARAM lParam;
	int oldx;
	int oldy;
} RCE_MSG;


/******************************************************************************

	CRI_Success

	CeRapiInvoke̖߂l

******************************************************************************/

BOOL CRI_Success(HRESULT hr)
{
	BOOL bOK = TRUE;

	if(hr == ERROR_FILE_NOT_FOUND ||
		hr == ERROR_CALL_NOT_IMPLEMENTED ||
		hr == ERROR_EXCEPTION_IN_SERVICE){
		bOK = FALSE;
	}else{
		bOK = (SUCCEEDED(hr));
	}
	return bOK;
}


/******************************************************************************

	SendCeBuf

	obt@M

******************************************************************************/

static BYTE *GetCeBuf(WCHAR *dll, WCHAR *func)
{
	HRESULT hr;
	DWORD dwBuf;
	BYTE *pbuf = NULL;
	BYTE *cBuf;

	hr = CeRapiInvoke(dll, func, 0, NULL, &dwBuf, &pbuf, NULL, 0);
	if(CRI_Success(hr) && pbuf != NULL){
		cBuf = (BYTE *)LocalAlloc(LMEM_FIXED, dwBuf);
		if(cBuf == NULL){
#ifndef _WINCE_LAGENDA
			CeRapiFreeBuffer(pbuf);
#endif
			return NULL;
		}
		CopyMemory(cBuf, pbuf, dwBuf);
#ifndef _WINCE_LAGENDA
		CeRapiFreeBuffer(pbuf);
#endif
		return cBuf;
	}
	return NULL;
}


/******************************************************************************

	SendCeBuf

	obt@M

******************************************************************************/

static BOOL SendCeBuf(WCHAR *dll, WCHAR *func, BYTE *buf, int len)
{
	HRESULT hr;
	DWORD dwBuf;
	BYTE *pbuf = NULL;
	BYTE *cBuf;

	cBuf = (BYTE *)LocalAlloc(LMEM_FIXED, len);
	if(cBuf == NULL){
		return FALSE;
	}
	CopyMemory(cBuf, buf, len);

	hr = CeRapiInvoke(dll, func, len, cBuf, &dwBuf, &pbuf, NULL, 0);
	LocalFree(cBuf);
	if(CRI_Success(hr)){
		if(pbuf != NULL){
#ifndef _WINCE_LAGENDA
			CeRapiFreeBuffer(pbuf);
#endif
		}
		return TRUE;
	}
	return FALSE;
}


/******************************************************************************

	PutFile

	t@C]

******************************************************************************/

static BOOL PutFile(char *tszSrcFile, WCHAR *wszDestFile)
{
	HANDLE hSrc, hDest, hFind;
	WIN32_FIND_DATA wfd;
	DWORD dwNumRead, dwNumWritten;
	BYTE Buffer[4096];

	hFind = FindFirstFile(tszSrcFile, &wfd);
	if(INVALID_HANDLE_VALUE == hFind){
		return FALSE;
	}    
	FindClose(hFind);

	hSrc = CreateFile(tszSrcFile, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	hDest = CeCreateFile(wszDestFile, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	do {
		if(ReadFile(hSrc, &Buffer, sizeof(Buffer), &dwNumRead, NULL)){
			if(!CeWriteFile(hDest, &Buffer, dwNumRead, &dwNumWritten, NULL)){
				CeCloseHandle(hDest);
				CloseHandle(hSrc);
				return FALSE;
			}
		}else{
			CeCloseHandle(hDest);
			CloseHandle(hSrc);
			return FALSE;
		}
	} while (dwNumRead);

	CeCloseHandle(hDest);
	CloseHandle(hSrc);
	return TRUE;
}


/******************************************************************************

	InitRce

	

******************************************************************************/

static BOOL InitRce(HWND hWnd)
{
	RCE_INIT *ri;
#ifndef _WINCE_LAGENDA
	SYSTEM_INFO si;
#endif
	RECT rect;
	char AppPath[BUF_SIZE];
	char DllPath[BUF_SIZE];
	char *p, *r;

	//AvP[ṼpX擾
	GetModuleFileName(hInst, AppPath, BUF_SIZE - 1);
	p = AppPath;
	while(*p != '\0'){
		if(IsDBCSLeadByte((BYTE)*p) == TRUE){
			p++;
		}else if(*p == '\\'){
			r = p;
		}
		p++;
	}
	*r = '\0';

	*DllPath = '\0';
#ifdef _WINCE_LAGENDA
	wsprintf(DllPath, "%s\\"RCE_DLL, AppPath);
#else
	CeGetSystemInfo(&si);
	switch(si.wProcessorArchitecture)
	{
	case PROCESSOR_ARCHITECTURE_MIPS:
		wsprintf(DllPath, "%s\\MIPS\\"RCE_DLL, AppPath);
		break;

	case PROCESSOR_ARCHITECTURE_ARM:
		wsprintf(DllPath, "%s\\ARM\\"RCE_DLL, AppPath);
		break;

	default:
		switch(si.dwProcessorType)
		{
		case PROCESSOR_MIPS_R2000:
		case PROCESSOR_MIPS_R3000:
		case PROCESSOR_MIPS_R4000:
			wsprintf(DllPath, "%s\\MIPS\\"RCE_DLL, AppPath);
			break;

		case PROCESSOR_HITACHI_SH3:
		case PROCESSOR_HITACHI_SH3E:
		case PROCESSOR_SHx_SH3:
			wsprintf(DllPath, "%s\\SH3\\"RCE_DLL, AppPath);
			break;

		case PROCESSOR_HITACHI_SH4:
		case PROCESSOR_SHx_SH4:
			wsprintf(DllPath, "%s\\SH4\\"RCE_DLL, AppPath);
			break;

		case PROCESSOR_STRONGARM:
		case PROCESSOR_ARM720:
		case PROCESSOR_ARM820:
		case PROCESSOR_ARM920:
		case PROCESSOR_ARM_7TDMI:
			wsprintf(DllPath, "%s\\ARM\\"RCE_DLL, AppPath);
			break;
		}
		break;
	}
#endif

	if(*DllPath == '\0'){
		SetCursor(LoadCursor(NULL, IDC_ARROW));
		MessageBox(hWnd, "CPU was not discriminable", "Error", MB_ICONEXCLAMATION);
		return FALSE;
	}

	if(PutFile(DllPath, RCE_DLL_CE) == FALSE){
		SetCursor(LoadCursor(NULL, IDC_ARROW));
		MessageBox(hWnd, "Failed in transmission of 'rCE.dll'", "Error", MB_ICONEXCLAMATION);
		SetCursor(LoadCursor(NULL, IDC_WAIT));
	}

	ri = (RCE_INIT *)GetCeBuf(RCE_DLL_W, L"RceInit");
	if(ri == NULL){
		MessageBox(hWnd, "Initialization failure", "Error", MB_ICONEXCLAMATION);
		return FALSE;
	}
	SetWindowPos(hWnd, 0, 0, 0, ri->x, ri->y, SWP_NOMOVE | SWP_NOZORDER);
	GetClientRect(hWnd, &rect);
	SetWindowPos(hWnd, 0, 0, 0,
		ri->x + (ri->x - (rect.right - rect.left)),
		ri->y + (ri->y - (rect.bottom - rect.top)),
		SWP_NOMOVE | SWP_NOZORDER);
	ce_x = ri->x;
	ce_y = ri->y;
	LocalFree(ri);
	return TRUE;
}


/******************************************************************************

	UninitRce

	RAPȈI

******************************************************************************/

static BOOL UninitRce(void)
{
#ifndef _DEBUG
	CeDeleteFile(RCE_DLL_CE);
	CeDeleteFile(TMP_FILE);
#endif
	CeRapiUninit();
	return TRUE;
}


/******************************************************************************

	GetBitsToSize

	Bitmap̃TCY擾

******************************************************************************/

static int GetBitsToSize(int x, int y, int bits)
{
	int size;

	size = (((x * bits) / 8) % 4) ? ((((x * bits) / 8) / 4) + 1) * 4 : (x * bits) / 8;
	switch(bits)
	{
	case 1:
		size = sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (2 - 1) + size * y;
		break;

	case 2:
		size = (((x * 4) / 8) % 4) ? ((((x * 4) / 8) / 4) + 1) * 4 : (x * 4) / 8;
	case 4:
		size = sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (16 - 1) + size * y;
		break;

	case 8:
		size = sizeof(BITMAPINFO) + sizeof(RGBQUAD) * (256 - 1) + size * y;
		break;

	case 24:
		size = sizeof(BITMAPINFO) + size * y;
		break;

	default:
		size = 0;
		break;
	}
	return size;
}


/******************************************************************************

	DibToDdb

	DIBDDBɕϊ

******************************************************************************/

static HBITMAP DibToDdb(HWND hWnd, BYTE *buf)
{
	HDC hdc;
	HBITMAP hbitmap = NULL;
	int plt = 0;

	if(buf == NULL){
		return NULL;
	}
	hdc = GetDC(hWnd);
	switch((op_cebits == 24) ? op_rcebits : op_cebits)
	{
	case 1:
		plt = (2 - 1);
		break;

	case 2:
	case 4:
		plt = (16 - 1);
		break;

	case 8:
		plt = (256 - 1);
		break;
	}
	hbitmap = CreateDIBitmap(hdc, (BITMAPINFOHEADER *)buf, CBM_INIT,
		buf + sizeof(BITMAPINFO) + sizeof(RGBQUAD) * plt, (BITMAPINFO *)buf, DIB_RGB_COLORS);
	ReleaseDC(hWnd, hdc);
	return hbitmap;
}


/******************************************************************************

	GetRemoteDib

	ʐM̉摜M

******************************************************************************/

static int GetRemoteDib(HWND hWnd, BYTE *buf, int size, int init_diff)
{
	RCE_INFO *ri;
	HRESULT hr;
	DWORD dwBuf;
	BYTE *pbuf = NULL;

	ri = (RCE_INFO *)LocalAlloc(LPTR, sizeof(RCE_INFO));
	if(ri == NULL){
        return -1;
	}
	ri->cebits = op_cebits;
	ri->rcebits = op_rcebits;
	ri->compression = op_compression;
	ri->diff = op_diff;
	ri->init_diff = init_diff;

	hr = CeRapiInvoke(RCE_DLL_W, L"GetRemoteDib", sizeof(RCE_INFO), (BYTE *)ri, &dwBuf, &pbuf, NULL, 0);
	LocalFree(ri);
	if(CRI_Success(hr)){
		if(pbuf == NULL){
			//O񂩂ωȂ
			return 1;
		}
#ifdef _DEBUG
		{
			MSG msg;
			TCHAR msgbuf[BUF_SIZE];

			PeekMessage(&msg, NULL, WM_CLOSE, WM_CLOSE, PM_NOREMOVE);
			if(msg.message != WM_CLOSE){
				wsprintf(msgbuf, "%s - [recv: %d byte]", WINDOW_TITLE, dwBuf);
				SetWindowText(hWnd, msgbuf);
			}
		}
#endif
		if(op_compression != 0){
			//kꂽf[^WJ
			extend(pbuf, dwBuf, buf, (op_cebits == 24) ? op_rcebits : op_cebits);
		}else{
			CopyMemory(buf, pbuf, size);
		}
#ifndef _WINCE_LAGENDA
		CeRapiFreeBuffer(pbuf);
#endif
	}else{
		return -1;
	}
	return 0;
}


/******************************************************************************

	memdiff

	̍

******************************************************************************/

static BOOL memdiff(long *to, long *from, int size)
{
	int i;

	for(i = 0; i < size; i++){
		*(to + i) = *(to + i) ^ *(from + i);
	}
	return TRUE;
}


/******************************************************************************

	RecvThread

	MXbh

******************************************************************************/

static unsigned int CALLBACK RecvThread(HWND hWnd)
{
	MSG msg;
	HBITMAP hbmp;
	BYTE *buf;
	int size;
	int ret;

	size = GetBitsToSize(ce_x, ce_y, (op_cebits == 24) ? op_rcebits : op_cebits);
	buf = (BYTE *)LocalAlloc(LMEM_FIXED, size);
	if(buf == NULL){
		_endthreadex(0);
		return 0;
	}

	while(1){
		if(op_refresh_wait != 0){
			Sleep(op_refresh_wait);
		}
		PeekMessage(&msg, NULL, WM_CLOSE, WM_CLOSE, PM_NOREMOVE);
		if(msg.message == WM_CLOSE){
			break;
		}
		if(IsIconic(hWnd) == TRUE){
			//ACRĂꍇ͏Ȃ
			Sleep(100);
			continue;
		}
		//摜擾
		ret = GetRemoteDib(hWnd, buf, size, 0);
		if(ret == 0){
			PeekMessage(&msg, NULL, WM_CLOSE, WM_CLOSE, PM_NOREMOVE);
			if(msg.message == WM_CLOSE){
				break;
			}
			if(op_diff != 0){
				//
				memdiff((long *)dib, (long *)buf, size / sizeof(long));
			}else{
				CopyMemory(dib, buf, size);
			}
			hbmp = DibToDdb(hWnd, dib);
			if(hbmp != NULL){
				SendMessage(hWnd, WM_BMP_REFRESH, 0, (LPARAM)hbmp);
			}
		}else if(ret == -1){
			PostMessage(hWnd, WM_DISCONNECT, 0, 0);
			break;
		}
	}
	LocalFree(buf);
	_endthreadex(0);
	return 0;
}


/******************************************************************************

	SendThread

	MXbh

******************************************************************************/

static unsigned int CALLBACK SendThread(HWND hWnd)
{
	MSG msg;
	RCE_MSG rm;
	POINT pt;
	int oldx, oldy;

	while(1){
		GetMessage(&msg, NULL, 0, 0);
		switch(msg.message)
		{
		case WM_CLOSE:
			_endthreadex(0);
			return 0;

		case WM_KEYDOWN:
		case WM_KEYUP:
		case WM_SYSKEYDOWN:
		case WM_SYSKEYUP:
		case WM_IME_CHAR:
			if(op_use_key == 0){
				break;
			}
			rm.message = msg.message;
			rm.wParam = msg.wParam;
			rm.lParam = msg.lParam;
			rm.oldx = 0; rm.oldy = 0;
			SendCeBuf(RCE_DLL_W, L"RceEvent", (BYTE *)&rm, sizeof(RCE_MSG));
			break;

		case WM_MOUSEMOVE:
			if(op_use_mouse == 0){
				break;
			}
			rm.message = (op_mouse_msg == 0) ? msg.message : WM_MOUSEMOVE_MSG;
			rm.wParam = msg.wParam;
			rm.lParam = msg.lParam;
			rm.oldx = oldx;
			rm.oldy = oldy;
			oldx = LOWORD(msg.lParam);
			oldy = HIWORD(msg.lParam);
			SendCeBuf(RCE_DLL_W, L"RceEvent", (BYTE *)&rm, sizeof(RCE_MSG));
			break;

		case WM_LBUTTONDOWN:
			if(op_use_mouse == 0){
				break;
			}
			rm.message = (op_mouse_msg == 0) ? msg.message : WM_LBUTTONDOWN_MSG;
			rm.wParam = msg.wParam;
			rm.lParam = msg.lParam;
			rm.oldx = 0; rm.oldy = 0;
			oldx = LOWORD(msg.lParam);
			oldy = HIWORD(msg.lParam);
			SendCeBuf(RCE_DLL_W, L"RceEvent", (BYTE *)&rm, sizeof(RCE_MSG));
			break;

		case WM_LBUTTONUP:
			if(op_use_mouse == 0){
				break;
			}
			rm.message = (op_mouse_msg == 0) ? msg.message : WM_LBUTTONUP_MSG;
			rm.wParam = msg.wParam;
			rm.lParam = msg.lParam;
			rm.oldx = oldx;
			rm.oldy = oldy;
			SendCeBuf(RCE_DLL_W, L"RceEvent", (BYTE *)&rm, sizeof(RCE_MSG));
			break;

		case WM_LBUTTONCLICK:
			if(op_use_mouse == 0){
				break;
			}
			rm.message = (op_mouse_msg == 0) ? msg.message : WM_LBUTTONCLICK_MSG;
			rm.wParam = msg.wParam;
			rm.lParam = msg.lParam;
			rm.oldx = 0; rm.oldy = 0;
			SendCeBuf(RCE_DLL_W, L"RceEvent", (BYTE *)&rm, sizeof(RCE_MSG));
			break;

		case WM_LBUTTONDBLCLK:
			if(op_use_mouse == 0){
				break;
			}
			rm.message = (op_mouse_msg == 0) ? msg.message : WM_LBUTTONDBLCLK_MSG;
			rm.wParam = msg.wParam;
			rm.lParam = msg.lParam;
			rm.oldx = 0; rm.oldy = 0;
			SendCeBuf(RCE_DLL_W, L"RceEvent", (BYTE *)&rm, sizeof(RCE_MSG));
			break;

		case WM_LBUTTONDOWNMOVE:
			if(op_use_mouse == 0){
				break;
			}
			GetCursorPos(&pt);
			ScreenToClient(hWnd, &pt);
			rm.message = (op_mouse_msg == 0) ? msg.message : WM_LBUTTONDOWNMOVE_MSG;
			rm.wParam = msg.wParam;
			rm.lParam = MAKELPARAM(pt.x, pt.y);
			rm.oldx = LOWORD(msg.lParam);
			rm.oldy = HIWORD(msg.lParam);
			oldx = pt.x;
			oldy = pt.y;
			SendCeBuf(RCE_DLL_W, L"RceEvent", (BYTE *)&rm, sizeof(RCE_MSG));
			break;
		}
	}
	_endthreadex(0);
	return 0;
}


/******************************************************************************

	CreateRecvThread

	MXbh̍쐬

******************************************************************************/

static BOOL CreateRecvThread(HWND hWnd)
{
	r_hth = (HANDLE)_beginthreadex(NULL, 0, RecvThread, (void *)hWnd, 0, (unsigned *)&r_thId);
	return TRUE;
}


/******************************************************************************

	CreateSendThread

	MXbh̍쐬

******************************************************************************/

static BOOL CreateSendThread(HWND hWnd)
{
	s_hth = (HANDLE)_beginthreadex(NULL, 0, SendThread, (void *)hWnd, 0, (unsigned *)&s_thId);
	return TRUE;
}


/******************************************************************************

	EndRceThread

	Xbh̏I

******************************************************************************/

static BOOL EndRceThread(void)
{
	if(r_hth != NULL){
		PostThreadMessage((DWORD)r_thId, WM_CLOSE, 0, 0);
		WaitForSingleObject(r_hth, INFINITE);
		r_hth = NULL;
	}
	if(s_hth != NULL){
		PostThreadMessage((DWORD)s_thId, WM_CLOSE, 0, 0);
		WaitForSingleObject(s_hth, INFINITE);
		s_hth = NULL;
	}
	return TRUE;
}


/******************************************************************************

	GetIni

	INIt@C̓ǂݍ

******************************************************************************/

static void GetIni(HWND hWnd)
{
	char path[BUF_SIZE];
	char *p, *r;
	int left, top, width, height;

	GetModuleFileName(hInst, path, BUF_SIZE - 1);
	p = path;
	while(*p != '\0'){
		if(IsDBCSLeadByte((BYTE)*p) == TRUE){
			p++;
		}else if(*p == '\\'){
			r = p;
		}
		p++;
	}
	lstrcpy(r, INI_FILE);

	left = GetPrivateProfileInt("WINDOW", "left", 0, path);
	top = GetPrivateProfileInt("WINDOW", "top", 0, path);
	width = GetPrivateProfileInt("WINDOW", "width", 240, path);
	height = GetPrivateProfileInt("WINDOW", "height", 320, path);
	SetWindowPos(hWnd, 0, left, top, width, height, SWP_NOZORDER);

	op_auto_refresh = GetPrivateProfileInt("OPTION", "auto_refresh", 1, path);
	op_refresh_wait = GetPrivateProfileInt("OPTION", "refresh_wait", 0, path);
	op_cebits = GetPrivateProfileInt("OPTION", "cebits", 24, path);
	op_rcebits = GetPrivateProfileInt("OPTION", "rcebits", 4, path);
	op_compression = GetPrivateProfileInt("OPTION", "compression", 1, path);
	op_diff = GetPrivateProfileInt("OPTION", "diff", 1, path);
	op_use_key = GetPrivateProfileInt("OPTION", "use_key", 1, path);
	op_no_repeat = GetPrivateProfileInt("OPTION", "op_no_repeat", 0, path);
	op_use_mouse = GetPrivateProfileInt("OPTION", "use_mouse", 1, path);
	op_mouse_msg = GetPrivateProfileInt("OPTION", "mouse_msg", 0, path);
}


/******************************************************************************

	PutIni

	INIt@C֏

******************************************************************************/

static void PutIni(HWND hWnd)
{
	char buf[BUF_SIZE];
	char path[BUF_SIZE];
	char *p, *r;
	RECT rect;

	GetModuleFileName(hInst, path, BUF_SIZE - 1);
	p = path;
	while(*p != '\0'){
		if(IsDBCSLeadByte((BYTE)*p) == TRUE){
			p++;
		}else if(*p == '\\'){
			r = p;
		}
		p++;
	}
	lstrcpy(r, INI_FILE);

	GetWindowRect(hWnd, &rect);
	wsprintf(buf, "%d", rect.left);
	WritePrivateProfileString("WINDOW", "left", buf, path);
	wsprintf(buf, "%d", rect.top);
	WritePrivateProfileString("WINDOW", "top", buf, path);
	wsprintf(buf, "%d", rect.right - rect.left);
	WritePrivateProfileString("WINDOW", "width", buf, path);
	wsprintf(buf, "%d", rect.bottom -rect.top);
	WritePrivateProfileString("WINDOW", "height", buf, path);

	wsprintf(buf, "%d", op_auto_refresh);
	WritePrivateProfileString("OPTION", "auto_refresh", buf, path);
	wsprintf(buf, "%d", op_refresh_wait);
	WritePrivateProfileString("OPTION", "refresh_wait", buf, path);
	wsprintf(buf, "%d", op_cebits);
	WritePrivateProfileString("OPTION", "cebits", buf, path);
	wsprintf(buf, "%d", op_rcebits);
	WritePrivateProfileString("OPTION", "rcebits", buf, path);
	wsprintf(buf, "%d", op_compression);
	WritePrivateProfileString("OPTION", "compression", buf, path);
	wsprintf(buf, "%d", op_diff);
	WritePrivateProfileString("OPTION", "diff", buf, path);
	wsprintf(buf, "%d", op_use_key);
	WritePrivateProfileString("OPTION", "use_key", buf, path);
	wsprintf(buf, "%d", op_no_repeat);
	WritePrivateProfileString("OPTION", "op_no_repeat", buf, path);
	wsprintf(buf, "%d", op_use_mouse);
	WritePrivateProfileString("OPTION", "use_mouse", buf, path);
	wsprintf(buf, "%d", op_mouse_msg);
	WritePrivateProfileString("OPTION", "mouse_msg", buf, path);
}


/******************************************************************************

	SubClassEditProc

	TuNXEBhEvV[W

******************************************************************************/

static LRESULT CALLBACK SubClassEditProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
	case WM_CHAR:
		if((int)wParam == 0x0A && GetKeyState(VK_CONTROL) < 0){
			//Ctrl + Enter
			SendMessage(GetParent(hWnd), WM_COMMAND, ID_MENUITEM_SEND, 0);
			return 0;
		}
		if((int)wParam == 0x1B){
			//ESC
			SendMessage(GetParent(hWnd), WM_CLOSE, 0, 0);
			return 0;
		}
		break;
	}
	return CallWindowProc(EditWindowProcedure, hWnd, msg, wParam, lParam);
}


/******************************************************************************

	SendDlgProc

	񑗐M

******************************************************************************/

static BOOL CALLBACK SendDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char *buf;
	RECT rect;
	int len;

	switch(uMsg)
	{
	case WM_INITDIALOG:
		EditWindowProcedure = (WNDPROC)SetWindowLong(GetDlgItem(hDlg, IDC_EDIT_TEXT),
			GWL_WNDPROC, (long)SubClassEditProc);
		SendMessage(hDlg, WM_SIZE, 0, 0);
		break;

	case WM_SIZE:
		GetClientRect(hDlg, &rect);
		MoveWindow(GetDlgItem(hDlg, IDC_EDIT_TEXT), 0, 0, rect.right, rect.bottom, TRUE);
		break;

	case WM_CLOSE:
		SetWindowLong(GetDlgItem(hDlg, IDC_EDIT_TEXT), GWL_WNDPROC, (long)EditWindowProcedure);
		EditWindowProcedure = NULL;
		hEditDlg = NULL;
		EndDialog(hDlg, FALSE);
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case ID_MENUITEM_SEND:
			if(connect_falg == FALSE){
				break;
			}
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			len = SendDlgItemMessage(hDlg, IDC_EDIT_TEXT, WM_GETTEXTLENGTH, 0, 0) + 1;
			buf = LocalAlloc(LPTR, len + 1);
			GetDlgItemText(hDlg, IDC_EDIT_TEXT, buf, len);
			if(*buf != '\0'){
				SendCeBuf(RCE_DLL_W, L"RceSendText", (BYTE *)buf, len);
			}
			LocalFree(buf);
			SetDlgItemText(hDlg, IDC_EDIT_TEXT, "");
			SetCursor(LoadCursor(NULL, IDC_ARROW));
			break;

		case ID_MENUITEM_CLOSE:
			SendMessage(hDlg, WM_CLOSE, 0, 0);
			break;
		}
		break;

	default:
		return FALSE;
	}
	return TRUE;
}


/******************************************************************************

	OptionDlgProc

	ݒ

******************************************************************************/

static BOOL CALLBACK OptionDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	case WM_INITDIALOG:
		//Rg[̏
		SendDlgItemMessage(hDlg, IDC_CHECK_AUTOREFRESH, BM_SETCHECK, op_auto_refresh, 0);
		SetDlgItemInt(hDlg, IDC_EDIT_REFRESHWAIT, op_refresh_wait, FALSE);

		switch(op_cebits)
		{
		case 1:
			SendDlgItemMessage(hDlg, IDC_RADIO_CE1, BM_SETCHECK, 1, 0);
			break;
		case 4:
			SendDlgItemMessage(hDlg, IDC_RADIO_CE4, BM_SETCHECK, 1, 0);
			break;
		case 8:
			SendDlgItemMessage(hDlg, IDC_RADIO_CE8, BM_SETCHECK, 1, 0);
			break;
		case 24:
		default:
			SendDlgItemMessage(hDlg, IDC_RADIO_CE24, BM_SETCHECK, 1, 0);
			break;
		}

		switch(op_rcebits)
		{
		case 1:
			SendDlgItemMessage(hDlg, IDC_RADIO_RCE1, BM_SETCHECK, 1, 0);
			break;
		case 2:
			SendDlgItemMessage(hDlg, IDC_RADIO_RCE2, BM_SETCHECK, 1, 0);
			break;
		case 4:
			SendDlgItemMessage(hDlg, IDC_RADIO_RCE4, BM_SETCHECK, 1, 0);
			break;
		case 8:
			SendDlgItemMessage(hDlg, IDC_RADIO_RCE8, BM_SETCHECK, 1, 0);
			break;
		case 24:
		default:
			SendDlgItemMessage(hDlg, IDC_RADIO_RCE24, BM_SETCHECK, 1, 0);
			break;
		}

		SendDlgItemMessage(hDlg, IDC_CHECK_COMP, BM_SETCHECK, op_compression, 0);
		SendDlgItemMessage(hDlg, IDC_CHECK_DIFF, BM_SETCHECK, op_diff, 0);
		SendDlgItemMessage(hDlg, IDC_CHECK_USEKEY, BM_SETCHECK, op_use_key, 0);
		SendDlgItemMessage(hDlg, IDC_CHECK_NOREPEAT, BM_SETCHECK, op_no_repeat, 0);
		SendDlgItemMessage(hDlg, IDC_CHECK_USEMOUSE, BM_SETCHECK, op_use_mouse, 0);
		SendDlgItemMessage(hDlg, IDC_CHECK_MOUSEMSG, BM_SETCHECK, op_mouse_msg, 0);

		SendMessage(hDlg, WM_COMMAND, IDC_CHECK_AUTOREFRESH, 0);
		SendMessage(hDlg, WM_COMMAND, IDC_RADIO_CE4, 0);
		SendMessage(hDlg, WM_COMMAND, IDC_CHECK_USEKEY, 0);
		SendMessage(hDlg, WM_COMMAND, IDC_CHECK_USEMOUSE, 0);
		break;

	case WM_CLOSE:
		EndDialog(hDlg, FALSE);
		break;

	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
		case IDC_CHECK_AUTOREFRESH:
			if(SendDlgItemMessage(hDlg, IDC_CHECK_AUTOREFRESH, BM_GETCHECK, 0, 0) == 1){
				EnableWindow(GetDlgItem(hDlg, IDC_EDIT_REFRESHWAIT), TRUE);
			}else{
				EnableWindow(GetDlgItem(hDlg, IDC_EDIT_REFRESHWAIT), FALSE);
			}
			break;

		case IDC_RADIO_CE1:
		case IDC_RADIO_CE4:
		case IDC_RADIO_CE8:
		case IDC_RADIO_CE24:
			if(SendDlgItemMessage(hDlg, IDC_RADIO_CE24, BM_GETCHECK, 0, 0) == 1){
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE1), TRUE);
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE2), TRUE);
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE4), TRUE);
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE8), TRUE);
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE24), TRUE);
			}else{
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE1), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE2), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE4), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE8), FALSE);
				EnableWindow(GetDlgItem(hDlg, IDC_RADIO_RCE24), FALSE);
			}
			break;

		case IDC_CHECK_USEKEY:
			if(SendDlgItemMessage(hDlg, IDC_CHECK_USEKEY, BM_GETCHECK, 0, 0) == 1){
				EnableWindow(GetDlgItem(hDlg, IDC_CHECK_NOREPEAT), TRUE);
			}else{
				EnableWindow(GetDlgItem(hDlg, IDC_CHECK_NOREPEAT), FALSE);
			}
			break;

		case IDC_CHECK_USEMOUSE:
			if(SendDlgItemMessage(hDlg, IDC_CHECK_USEMOUSE, BM_GETCHECK, 0, 0) == 1){
				EnableWindow(GetDlgItem(hDlg, IDC_CHECK_MOUSEMSG), TRUE);
			}else{
				EnableWindow(GetDlgItem(hDlg, IDC_CHECK_MOUSEMSG), FALSE);
			}
			break;

		case IDCANCEL:
			EndDialog(hDlg, FALSE);
			break;

		case IDOK:
			//ݒ̎擾
			op_auto_refresh = SendDlgItemMessage(hDlg, IDC_CHECK_AUTOREFRESH, BM_GETCHECK, 0, 0);
			op_refresh_wait = GetDlgItemInt(hDlg, IDC_EDIT_REFRESHWAIT, NULL, FALSE);

			if(SendDlgItemMessage(hDlg, IDC_RADIO_CE1, BM_GETCHECK, 0, 0) == 1){
				op_cebits = 1;
			}else if(SendDlgItemMessage(hDlg, IDC_RADIO_CE4, BM_GETCHECK, 0, 0) == 1){
				op_cebits = 4;
			}else if(SendDlgItemMessage(hDlg, IDC_RADIO_CE8, BM_GETCHECK, 0, 0) == 1){
				op_cebits = 8;
			}else{
				op_cebits = 24;
			}

			if(SendDlgItemMessage(hDlg, IDC_RADIO_RCE1, BM_GETCHECK, 0, 0) == 1){
				op_rcebits = 1;
			}else if(SendDlgItemMessage(hDlg, IDC_RADIO_RCE2, BM_GETCHECK, 0, 0) == 1){
				op_rcebits = 2;
			}else if(SendDlgItemMessage(hDlg, IDC_RADIO_RCE4, BM_GETCHECK, 0, 0) == 1){
				op_rcebits = 4;
			}else if(SendDlgItemMessage(hDlg, IDC_RADIO_RCE8, BM_GETCHECK, 0, 0) == 1){
				op_rcebits = 8;
			}else{
				op_rcebits = 24;
			}

			op_compression = SendDlgItemMessage(hDlg, IDC_CHECK_COMP, BM_GETCHECK, 0, 0);
			op_diff = SendDlgItemMessage(hDlg, IDC_CHECK_DIFF, BM_GETCHECK, 0, 0);
			op_use_key = SendDlgItemMessage(hDlg, IDC_CHECK_USEKEY, BM_GETCHECK, 0, 0);
			op_no_repeat = SendDlgItemMessage(hDlg, IDC_CHECK_NOREPEAT, BM_GETCHECK, 0, 0);
			op_use_mouse = SendDlgItemMessage(hDlg, IDC_CHECK_USEMOUSE, BM_GETCHECK, 0, 0);
			op_mouse_msg = SendDlgItemMessage(hDlg, IDC_CHECK_MOUSEMSG, BM_GETCHECK, 0, 0);
			EndDialog(hDlg, TRUE);
			break;
		}
		break;

	default:
		return FALSE;
	}
	return TRUE;
}


/******************************************************************************

	WndProc

	CEBhEvV[W

******************************************************************************/

static LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	static HBITMAP hbitmap;
	static int click_flag;
	static BOOL move_flag;
	static WPARAM wp, m_wp;
	static LPARAM lp, m_lp;
    RAPIINIT ri = {sizeof(RAPIINIT)};
	HDC hdc;
	HDC drawdc;
	HBITMAP hbmp;
	HBITMAP hRetBmp;
	PAINTSTRUCT ps;
	RECT rect;
	int i;

	switch(msg)
	{
	case WM_CREATE:
		GetIni(hWnd);
		break;

	case WM_SIZE:
		break;

	case WM_CLOSE:
	case WM_ENDSESSION:
		SetCursor(LoadCursor(NULL, IDC_WAIT));
		EndRceThread();
		if(connect_falg == TRUE){
			UninitRce();
		}
		SetCursor(LoadCursor(NULL, IDC_ARROW));

		if(hbitmap != NULL){
			DeleteObject(hbitmap);
			hbitmap = NULL;
		}
		if(dib != NULL){
			LocalFree(dib);
			dib = NULL;
		}

		PutIni(hWnd);
		DestroyWindow(hWnd);
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);

		GetClientRect(hWnd,(LPRECT)&rect);

		if(hbitmap != NULL){
			drawdc = CreateCompatibleDC(hdc);
			hRetBmp = SelectObject(drawdc, hbitmap);

			BitBlt(hdc, ps.rcPaint.left, ps.rcPaint.top, ps.rcPaint.right, ps.rcPaint.bottom,
				drawdc, ps.rcPaint.left, ps.rcPaint.top, SRCCOPY);
			SelectObject(drawdc, hRetBmp);
			DeleteDC(drawdc);
		}

		EndPaint(hWnd, &ps);
		break;

	case WM_ERASEBKGND:
		hdc = (HDC)wParam;
		GetClientRect(hWnd,(LPRECT)&rect);
		FillRect(hdc, &rect, (HBRUSH)GetStockObject(WHITE_BRUSH));
		return 1;

	case WM_KEYDOWN:
	case WM_SYSKEYDOWN:
		if(lParam & (1 << 30) &&
			(op_no_repeat == 1 ||
			(int)wParam == VK_SHIFT ||
			(int)wParam == VK_CONTROL ||
			(int)wParam == VK_MENU)){
			break;
		}
		if((int)wParam == VK_PROCESSKEY){
			break;
		}
	case WM_KEYUP:
	case WM_SYSKEYUP:
	case WM_IME_CHAR:
		if(connect_falg == FALSE){
			break;
		}
		//L[M
		PostThreadMessage((DWORD)s_thId, msg, wParam, lParam);
		break;

	case WM_MOUSEMOVE:
		if(wParam != MK_LBUTTON || connect_falg == FALSE){
			return DefWindowProc(hWnd, msg, wParam, lParam);
		}
		m_wp = wParam;
		m_lp = lParam;
		move_flag = TRUE;
		//}EXړp^C}[
		SetTimer(hWnd, ID_MOUSEMOVE_TIMER, 100, NULL);
		break;

	case WM_LBUTTONDOWN:
		SetCapture(hWnd);
		if(connect_falg == FALSE){
			break;
		}
		if(click_flag == 2){
			if(abs(LOWORD(lParam) - LOWORD(lp)) > GetSystemMetrics(SM_CXDOUBLECLK) ||
				abs(HIWORD(lParam) - HIWORD(lp)) > GetSystemMetrics(SM_CYDOUBLECLK)){
				//NbN
				PostThreadMessage((DWORD)s_thId, WM_LBUTTONCLICK, wp, lp);
			}else{
				//_uNbN̉\
				click_flag = 3;
				break;
			}
		}
		m_wp = wp = wParam;
		m_lp = lp = lParam;
		click_flag = 1;
		//NbNA_uNbNp^C}[
		SetTimer(hWnd, ID_CLICK_TIMER, GetDoubleClickTime(), NULL);
		break;

	case WM_LBUTTONUP:
		ReleaseCapture();
		if(connect_falg == FALSE){
			break;
		}
		KillTimer(hWnd, ID_MOUSEMOVE_TIMER);
		if(click_flag == 1){
			if(abs(LOWORD(m_lp) - LOWORD(lp)) > GetSystemMetrics(SM_CXDOUBLECLK) ||
				abs(HIWORD(m_lp) - HIWORD(lp)) > GetSystemMetrics(SM_CYDOUBLECLK)){
				//}EX_E{}EXړ
				KillTimer(hWnd, ID_CLICK_TIMER);
				PostThreadMessage((DWORD)s_thId, WM_LBUTTONDOWNMOVE, wp, lp);
				PostThreadMessage((DWORD)s_thId, WM_LBUTTONUP, wParam, lParam);
			}else{
				//NbN_uNbN
				click_flag = 2;
			}
		}else if(click_flag == 3){
			//_uNbN
			KillTimer(hWnd, ID_CLICK_TIMER);
			PostThreadMessage((DWORD)s_thId, WM_LBUTTONDBLCLK, wParam, lParam);
			click_flag = 0;
		}else{
			//}EXAbv
			if(move_flag == TRUE){
				PostThreadMessage((DWORD)s_thId, WM_MOUSEMOVE, m_wp, m_lp);
			}
			PostThreadMessage((DWORD)s_thId, msg, wParam, lParam);
		}
		break;

	case WM_TIMER:
		switch(wParam)
		{
		case ID_CLICK_TIMER:
			KillTimer(hWnd, ID_CLICK_TIMER);
			if(click_flag == 2){
				//NbN
				PostThreadMessage((DWORD)s_thId, WM_LBUTTONCLICK, wp, lp);
			}else if(click_flag == 3){
				//NbN{}EX_E
				PostThreadMessage((DWORD)s_thId, WM_LBUTTONCLICK, wp, lp);
				PostThreadMessage((DWORD)s_thId, WM_LBUTTONDOWN, wp, lp);
			}else{
				if(abs(LOWORD(m_lp) - LOWORD(lp)) > GetSystemMetrics(SM_CXDOUBLECLK) ||
					abs(HIWORD(m_lp) - HIWORD(lp)) > GetSystemMetrics(SM_CYDOUBLECLK)){
					//}EX_E{}EXړ
					PostThreadMessage((DWORD)s_thId, WM_LBUTTONDOWNMOVE, wp, lp);
				}else{
					//}EX_E
					PostThreadMessage((DWORD)s_thId, WM_LBUTTONDOWN, wp, lp);
				}
			}
			click_flag = 0;
			break;

		case ID_MOUSEMOVE_TIMER:
			if(click_flag == 1 || click_flag == 3){
				//}EX
				break;
			}
			KillTimer(hWnd, ID_MOUSEMOVE_TIMER);
			//}EXړ
			PostThreadMessage((DWORD)s_thId, WM_MOUSEMOVE, m_wp, m_lp);
			move_flag = FALSE;
			break;
		}
		break;

	case WM_BMP_REFRESH:
		if(hbitmap != NULL){
			DeleteObject(hbitmap);
		}
		hbitmap = (HBITMAP)lParam;
		InvalidateRect(hWnd, NULL, FALSE);
		UpdateWindow(hWnd);
		break;

	case WM_DISCONNECT:
		SendMessage(hWnd, WM_COMMAND, ID_MENUITEM_DISCONNECT, 0);
		break;

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case ID_MENUITEM_CONNECT:
			if(connect_falg == TRUE){
				break;
			}
			SetCursor(LoadCursor(NULL, IDC_WAIT));

#ifdef _WINCE_LAGENDA
			if(FAILED(CeRapiInit())){
				SetCursor(LoadCursor(NULL, IDC_ARROW));
				MessageBox(hWnd, "CeRapiInit failed", "Error", MB_ICONEXCLAMATION);
				break;
			}
			if(InitRce(hWnd) == FALSE){
				UninitRce();
				SetCursor(LoadCursor(NULL, IDC_ARROW));
				break;
			}
			if(dib != NULL){
				LocalFree(dib);
			}
			i = GetBitsToSize(ce_x, ce_y, (op_cebits == 24) ? op_rcebits : op_cebits);
			dib = (BYTE *)LocalAlloc(LMEM_FIXED, i);
			if(dib == NULL || GetRemoteDib(hWnd, dib, i, 1) == -1){
				UninitRce();
				SetCursor(LoadCursor(NULL, IDC_ARROW));
				MessageBox(hWnd, "GetRemoteDib failed", "Error", MB_ICONEXCLAMATION);
				break;
			}
			hbmp = DibToDdb(hWnd, dib);
			if(hbmp != NULL){
				SendMessage(hWnd, WM_BMP_REFRESH, 0, (LPARAM)hbmp);
			}
			if(op_auto_refresh == TRUE){
				CreateRecvThread(hWnd);
			}
			CreateSendThread(hWnd);
			connect_falg = TRUE;
			EnableMenuItem(GetSubMenu(GetMenu(hWnd), 0), ID_MENUITEM_CONNECT, MF_GRAYED);
			SetCursor(LoadCursor(NULL, IDC_ARROW));
#else
			if(FAILED(CeRapiInitEx(&ri))){
				SetCursor(LoadCursor(NULL, IDC_ARROW));
				MessageBox(hWnd, "CeRapiInitEx failed", "Error", MB_ICONEXCLAMATION);
				break;
			}
			if((WaitForSingleObject(ri.heRapiInit, 15000) == WAIT_OBJECT_0) && SUCCEEDED(ri.hrRapiInit)){
				if(InitRce(hWnd) == FALSE){
					UninitRce();
					SetCursor(LoadCursor(NULL, IDC_ARROW));
					break;
				}
				if(dib != NULL){
					LocalFree(dib);
				}
				i = GetBitsToSize(ce_x, ce_y, (op_cebits == 24) ? op_rcebits : op_cebits);
				dib = (BYTE *)LocalAlloc(LMEM_FIXED, i);
				if(dib == NULL || GetRemoteDib(hWnd, dib, i, 1) == -1){
					UninitRce();
					SetCursor(LoadCursor(NULL, IDC_ARROW));
					MessageBox(hWnd, "GetRemoteDib failed", "Error", MB_ICONEXCLAMATION);
					break;
				}
				hbmp = DibToDdb(hWnd, dib);
				if(hbmp != NULL){
					SendMessage(hWnd, WM_BMP_REFRESH, 0, (LPARAM)hbmp);
				}
				if(op_auto_refresh == TRUE){
					CreateRecvThread(hWnd);
				}
				CreateSendThread(hWnd);
				connect_falg = TRUE;
				EnableMenuItem(GetSubMenu(GetMenu(hWnd), 0), ID_MENUITEM_CONNECT, MF_GRAYED);
				SetCursor(LoadCursor(NULL, IDC_ARROW));
			}else{
				SetCursor(LoadCursor(NULL, IDC_ARROW));
				MessageBox(hWnd, "CeRapiInitEx failed", "Error", MB_ICONEXCLAMATION);
			}
#endif
			break;

		case ID_MENUITEM_DISCONNECT:
			if(connect_falg == FALSE){
				break;
			}
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			EndRceThread();
			UninitRce();
			connect_falg = FALSE;
			EnableMenuItem(GetSubMenu(GetMenu(hWnd), 0), ID_MENUITEM_CONNECT, MF_ENABLED);
			SetCursor(LoadCursor(NULL, IDC_ARROW));
			break;

		case ID_MENUITEM_REFRESH:
			if(connect_falg == FALSE){
				break;
			}
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			EndRceThread();
			if(dib != NULL){
				LocalFree(dib);
			}
			i = GetBitsToSize(ce_x, ce_y, (op_cebits == 24) ? op_rcebits : op_cebits);
			dib = (BYTE *)LocalAlloc(LMEM_FIXED, i);
			if(dib == NULL || GetRemoteDib(hWnd, dib, i, 1) == -1){
				UninitRce();
				SetCursor(LoadCursor(NULL, IDC_ARROW));
				MessageBox(hWnd, "GetRemoteDib failed", "Error", MB_ICONEXCLAMATION);
				break;
			}
			hbmp = DibToDdb(hWnd, dib);
			if(hbmp != NULL){
				SendMessage(hWnd, WM_BMP_REFRESH, 0, (LPARAM)hbmp);
			}
			if(op_auto_refresh == TRUE){
				CreateRecvThread(hWnd);
			}
			CreateSendThread(hWnd);
			SetCursor(LoadCursor(NULL, IDC_ARROW));
			break;

		case ID_MENUITEM_SENDSTRING:
			if(hEditDlg == NULL){
				POINT pt;

				hEditDlg = CreateDialog(hInst, MAKEINTRESOURCE(IDD_DIALOG_EDIT), NULL, SendDlgProc);
				pt.x = pt.y = 0;
				ClientToScreen(hWnd, &pt);
				SetWindowPos(hEditDlg, 0, pt.x, pt.y, 0, 0, SWP_NOZORDER | SWP_NOSIZE);
			}
			ShowWindow(hEditDlg, SW_SHOW);
			SetForegroundWindow(hEditDlg);
			break;

		case ID_MENUITEM_OPTION:
			if(DialogBoxParam(hInst, MAKEINTRESOURCE(IDD_DIALOG_OPTION), hWnd, OptionDlgProc, 0) == FALSE){
				break;
			}
			if(connect_falg == FALSE){
				break;
			}
			SendMessage(hWnd, WM_COMMAND, ID_MENUITEM_DISCONNECT, 0);
			SendMessage(hWnd, WM_COMMAND, ID_MENUITEM_CONNECT, 0);
			break;

		case ID_MENUITEM_CLOSE:
			SendMessage(hWnd, WM_CLOSE, 0, 0);
			break;
		}
		break;

	default:
		return DefWindowProc(hWnd, msg, wParam, lParam);
	}
	return 0;
}


/******************************************************************************

	InitApplication

	EBhENX̓o^

******************************************************************************/

static BOOL InitApplication(HINSTANCE hInstance)
{
	WNDCLASS wc;

	wc.style = 0;
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.lpszMenuName = MAKEINTRESOURCE(IDR_MENU_MAIN);
	wc.lpfnWndProc = (WNDPROC)WndProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON_MAIN));
	wc.hbrBackground = (HBRUSH)COLOR_BTNSHADOW;
	wc.lpszClassName = MAIN_WND_CLASS;
	return RegisterClass(&wc);
}


/******************************************************************************

	InitInstance

	EBhE̍쐬

******************************************************************************/

static HWND InitInstance(HINSTANCE hInstance, int CmdShow)
{
	HWND hWnd;

	/* EBhE̍쐬 */
	hWnd = CreateWindow(MAIN_WND_CLASS,
		WINDOW_TITLE,
		WS_BORDER | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		240,
		320,
		NULL, NULL, hInstance, NULL);

	if(hWnd == NULL){
		return NULL;
	}
	
	/* EBhE̕\ */
	ShowWindow(hWnd, CmdShow);
	UpdateWindow(hWnd);
	return hWnd;
}


/******************************************************************************

	WinMain

	C

******************************************************************************/

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	MSG msg;

	hInst = hInstance;

	/* EBhENX̓o^ */
	if(InitApplication(hInstance) == FALSE){
		return 0;
	}
	/* EBhE̍쐬 */
	if(InitInstance(hInstance, nCmdShow) == NULL){
		return 0;
	}

	/* EBhEbZ[W */
	while(GetMessage(&msg, NULL, 0, 0)){
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}
/* End of source */
